/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.issue;

import javax.annotation.Nullable;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.Rule;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;

public final class DefaultClientIssue
implements Issue {
    private final String severity;
    private final ActiveRule activeRule;
    private final String primaryMessage;
    private final TextRange textRange;
    private final ClientInputFile clientInputFile;
    private final Rule rule;

    public DefaultClientIssue(String severity, ActiveRule activeRule, Rule rule, String primaryMessage, @Nullable TextRange textRange, @Nullable ClientInputFile clientInputFile) {
        this.severity = severity;
        this.activeRule = activeRule;
        this.rule = rule;
        this.primaryMessage = primaryMessage;
        this.textRange = textRange;
        this.clientInputFile = clientInputFile;
    }

    public Integer getStartLineOffset() {
        return this.textRange != null ? Integer.valueOf(this.textRange.start().lineOffset()) : null;
    }

    public Integer getStartLine() {
        return this.textRange != null ? Integer.valueOf(this.textRange.start().line()) : null;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getRuleName() {
        return this.rule.name();
    }

    public String getRuleKey() {
        return this.activeRule.ruleKey().toString();
    }

    public String getMessage() {
        return this.primaryMessage;
    }

    public ClientInputFile getInputFile() {
        return this.clientInputFile;
    }

    public Integer getEndLineOffset() {
        return this.textRange != null ? Integer.valueOf(this.textRange.end().lineOffset()) : null;
    }

    public Integer getEndLine() {
        return this.textRange != null ? Integer.valueOf(this.textRange.end().line()) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("rule=").append(this.activeRule.ruleKey());
        sb.append(", severity=").append(this.severity);
        if (this.textRange != null) {
            sb.append(", line=").append(this.textRange.start().line());
        }
        if (this.clientInputFile != null) {
            sb.append(", file=").append(this.clientInputFile.getPath().toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

